'use strict';

/* Controllers */
function BCPProductionCtrl($scope, $rootScope, Company, $route, FrontCreatorCompanyForLoggedUser, CompanyInventory, FrontProductionCheckRestriction, DistributionSalesList){

    Company.init();
    $scope.company = Company;
    $scope.DistributionSalesList = DistributionSalesList.loadData();
    $scope.correctProductionAmount = true;
    $scope.productsAmount = 0;

    $scope.inventory = $route.current.locals.CompanyInventory;

    $scope.changes;
    $scope.methodType = 'bcp-production';
    $scope.number = /^\d+$/; 

    $scope.init = function() {
        $scope.productsAmount = $scope.company.production_amount;
        if($scope.productsAmount == ''){
            $scope.productsAmount = 0;
        }
        $scope.startVal = $scope.productsAmount;
        $scope.changes = [];
    }

    $scope.productionAmountChange = function() {
        $scope.correctProductionAmount =
            ($scope.productsAmount <= 3000000 && $scope.productsAmount >= 0);
    }

    $scope.showToken = function() {
        var message = {
            title: 'Sprawdzam poprawność danych.'
            ,msg: 'Sprawdzam poprawność danych. Proszę czekać...'
            ,type: 'loading'
        }

        $rootScope.$broadcast('Message:addMsg', message);
        FrontProductionCheckRestriction.check({'productionAmount':$scope.productsAmount},function(data){
            if(data.valid && data.errors.length == 0){
                $scope.changes = [];
                $scope.changes.push('Liczba produktów została zmieniona' + ' z ' + $scope.startVal + ' na ' + $scope.productsAmount + '.');
                $scope.broadcastToken();
            }else{
                $rootScope.$broadcast('ErrorRestrictions:openModal', data);
            }
            $rootScope.$broadcast('Message:delMsg', message);
        });
    }

    $scope.getSumPercent = function(){
        return DistributionSalesList.getSumPercent();
    }

    $scope.validSumPercent = function(){
        return DistributionSalesList.getSumPercent() == 100;
    }

    $scope.broadcastToken = function() {
        var params = {};
        params.title = 'Produkcja';
        params.tokensConfirmsMessage = 'controlPanel,'+'production';
        params.typeSubmitToken = 'REPRESENTATION';
        params.changes = $scope.changes;
        params.modal = true;

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.company, params, $scope.methodType);
    }

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType){
            if($scope.changes.length > 0) {
                $scope.company.production_amount = $scope.productsAmount;

                FrontCreatorCompanyForLoggedUser.save({data: $scope.company},function(data){
                    $scope.company = data;
                });

                DistributionSalesList.save(function(){});

                $scope.startVal = $scope.company.production_amount;
            }
        }
        $scope.changes = [];
    });

    $scope.isDistributionSalesForSegment = function(){
        return $scope.company.user_groups.user.market_segment.distribution_sales.length > 0;
    }

    $scope.changedForSave = function(prodAmount){
        return prodAmount.$valid && $scope.validSumPercent() && $scope.correctProductionAmount ;//&& $scope.isChangedProductsAmount();
    }

    $scope.isChangedProductsAmount = function(){
        return $scope.productsAmount != $scope.startVal;
    }

    $scope.increaseVal = function() {
        $scope.productsAmount = Number($scope.productsAmount) + 1;
    }

    $scope.decreaseVal = function() {
        $scope.productsAmount = Number($scope.productsAmount) - 1;
    }

}

BCPProductionCtrl.$inject = ['$scope', '$rootScope', 'Company', '$route', 'FrontCreatorCompanyForLoggedUser','CompanyInventory', 'FrontProductionCheckRestriction', 'DistributionSalesList'];

BCPProductionCtrl.getCompanyForLoggedUser = function($q, $route, $rootScope, FrontCreatorCompanyForLoggedUser){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorCompanyForLoggedUser.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BCPProductionCtrl.getInventory = function($q, $route, $rootScope, CompanyInventory){
    $rootScope.incLoading();
    var defer = $q.defer();
    CompanyInventory.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}